;+
; :Description:
;    Describe the procedure.
;
; :Params:
;    rr
;
; :Keywords:
;    lamrange
;    kevrange
;    nbins
;    interpol
;    _extra - used to set lamrange?
;
; :Author: richard
;
; :Changes - SW 2024 Aug 4, default lambda range is 0.6-20, but responses go down to 0.1,
;                           so made default range match the range used for the model spectra, 
;                           0.01-20: this may be slightly different from earlier versions
;-
function goes_interpolate_transfer, rr, lamrange = lamrange, kevrange = kevrange, $
  nbins = nbins,  _extra = _extra

  cnv = 12.39854
  usekev = keyword_set( kevrange ) ;interpolate in energy space, order by energy
  default, lamrange, [0.01, 20.]   ; match to range used for model spectra
  default, kevrange, reverse( cnv/lamrange )
  default, nbins, 2000


  gs = rr.gbshort
  
  gl = rr.gblong
  ts = rr.tsm
  tl = rr.tlm
  ws = rr.wsm
  wl = rr.wlm
  q = where( ts gt 0)

  ts = ts[q] & ws = ws[q]
  q = where( tl gt 0)
  tl = tl[q] & wl = wl[q]

  ews = cnv/ws
  ewl = cnv/wl
 
  ;Set up the photon energy grid  - why nbins+1?
  ; edg2 = get_edges(/edges_2, interpol(kevrange, nbins+1))
  ; wdg2 = get_edges(/edges_2, interpol(lamrange, nbins+1))
  edg2 = get_edges(/edges_2, interpol(kevrange, nbins))
  wdg2 = get_edges(/edges_2, interpol(lamrange, nbins))

  ; following puts bins in middle of 0.01 A values - appropriate?
  edgm = get_edges(edg2, /mean)
  ; Richard's version averages edges so puts them on 0.005 boundary, want 0.01
  wsm = interpol(lamrange, nbins)

  tsme = interpol( ts, ews, edgm,  _extra = _extra)>0
  tlme = interpol(tl, ewl, edgm,  _extra = _extra)>0

  ; use linear extrapolation, other options misbehave at sharp edges
  ; tsmw = interpol( ts, ws, wsm, _extra = _extra)>0
  ; tlmw = interpol( tl, wl, wsm, _extra = _extra)>0
  tsmw = interpol( ts, ws, wsm, _extra = _extra)>0
  tlmw = interpol( tl, wl, wsm, _extra = _extra)>0


  result = { ws: ws, wl: wl, ts: ts, tl: tl, tsme: tsme, tlme: tlme, tsmw: tsmw, tlmw: tlmw, wsm: wsm, wlm: wsm, $
    wave2: wdg2, ekev2: edg2, ekevm: edgm, ews: ews, ewl: ewl, gbshort: rr.gbshort, $
    gblong: rr.gblong, calibrated: rr.calibrated, w2ecnv: cnv, sat: rr.sat}
  return, result
end
