;+
; Project     : RHESSI
;
; Name        : RHESSI_SPECTRUM_ARCHIVE__DEFINE
;
; Purpose     : Define a RHESSI Archive Spectrum file data object.
;
; Category    : Synoptic Objects
;
; Syntax      : IDL> c=obj_new('rhessi_spectrum_archive')
;
; Written     : Kim tolbert, 20-Aug-2024, Modified from fermi_lat__define
; Modifications:
;
;-
;----------------------------------------------------------------
;
function rhessi_spectrum_archive::init,_ref_extra=extra

  if ~self->synop_spex::init() then return,0

  rhost='https://umbra.nascom.nasa.gov'

  parent = '/rhessi/rhessi_extras/spectra/fits_standard'

  self->setprop,rhost=rhost,ext='fits',org='day',$
    topdir=parent,/full, delim='/'
  return,1

end
;-----------------------------------------------------------------

;-- search method

function rhessi_spectrum_archive::search,tstart,tend,count=count,type=type,_ref_extra=extra

  type=''

  ; site::search expects yyyymmdd_hhmmss but we only have yyyymmdd_hhmm, so give it a modified regular expression  
  dyear='([0-9]{0,2}[0-9]{2})'
  mons='([0-9]{2})'
  days=mons
  hrs='([0-9]{0,2})'
  mins=hrs  
  regex = '([^_\\/ ]+)_?_'+dyear+mons+days+'_'+hrs+mins
  
  files=self->site::search(tstart,tend,_extra=extra, regex=regex, count=count)
  if count gt 0 then type=replicate('hxr/lightcurves',count) else files=''
  if count eq 0 then message,'No files found.',/cont

  return,files
end

;----------------------------------------------------------------

pro rhessi_spectrum_archive__define
  void={rhessi_spectrum_archive, inherits synop_spex}
  return & end

