;+
; Project     : RHESSI
;
; Name        : rhessi_spectrum_archive_hires_rsp__define
;
; Purpose     : Define a RHESSI Spectrum hires RSP (response file) data object.  
;
; Category    : Synoptic Objects
;
; Syntax      : IDL> c=obj_new('rhessi_spectrum_archive_hires_rsp')
;
; History     : Written 20-Aug-2024, Kim Tolbert, modified from fermi_lat_rsp__define

;
;-
;----------------------------------------------------------------
;
function rhessi_spectrum_archive_hires_rsp::init,_ref_extra=extra

if ~self->synop_spex::init() then return,0

rhost='https://umbra.nascom.nasa.gov'

parent = '/rhessi/rhessi_extras/spectra/fits_hires'

self->setprop,rhost=rhost,ext='fits',org='day',$
                 topdir=parent,/full, delim='/', suffix=''
return,1

end
;-----------------------------------------------------------------

;-- search method 
; tstart, tend should be in seconds since 1958 (tai) or some absolute time format

function rhessi_spectrum_archive_hires_rsp::search,tstart,tend,count=count,type=type,_ref_extra=extra

type=''
; expand search by a minute since rsp file names don't include seconds
;tstart60 = atime(anytim(tstart, fid='tai') - 60.)
;tend60 = atime(anytim(tend, fid='tai') + 60.)

; site::search expects yyyymmdd_hhmmss but we only have yyyymmdd_hhmm, so give it a modified regular expression
dyear='([0-9]{0,2}[0-9]{2})'
mons='([0-9]{2})'
days=mons
hrs='([0-9]{0,2})'
mins=hrs
regex = '([^_\\/ ]+)_?_'+dyear+mons+days+'_'+hrs+mins

files=self->site::search(tstart, tend, _extra=extra, regex=regex, count=count)
if count gt 0 then type=replicate('response matrix',count) else files=''
if count eq 0 then message,'No files found.',/cont

return,files
end

;----------------------------------------------------------------

pro rhessi_spectrum_archive_hires_rsp__define                 
void={rhessi_spectrum_archive_hires_rsp, inherits synop_spex}
return & end

