;+
; NAME:
;       XSLICE_BUTTONS
;
; PURPOSE:
;       Makes the buttons bitmaps for XSLICE.
;                                                                  
; CALLING SEQUENCE:
;       result = XSLICE_BUTTONS(GRAY=gray, BLACK=black)
;
; RETURNS:
;		A structure containing buttons.
;
; KEYWORD PARAMETERS:
;
;		GRAY - make gray buttons.
;
;		BLACK - make inverted buttons.
;
; MODIFICATION HISTORY:
;       27 Jun 2008: AdW, initial version
;
; AUTHOR:
;		Alfred de Wijn <dwijn@ucar.edu>
;
; $Id: xslice_buttons.pro 328 2008-06-27 22:25:35Z dwijn $
;-

function xslice_buttons, gray=gray, black=black
	forward_btn = rotate([ $
		[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], $
		[0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0], $
		[0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0], $
		[0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0], $
		[0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0], $
		[0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0], $
		[0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0], $
		[0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0], $
		[0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0], $
		[0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0], $
		[0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0], $
		[0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0], $
		[0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0], $
		[0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0], $
		[0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0], $
		[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0] ],7)

	pause_btn = rotate([ $
		[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0], $
		[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0] ],7)

	loop_btn = rotate([ $
		[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], $
		[0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0], $
		[0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0], $
		[0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0], $
		[0,0,1,1,1,1,1,1,1,1,0,1,1,1,0,0], $
		[0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0], $
		[0,1,1,1,0,0,1,1,0,0,0,0,1,1,1,0], $
		[0,1,1,1,0,0,1,0,0,0,0,0,1,1,1,0], $
		[0,1,1,1,0,0,0,0,0,1,0,0,1,1,1,0], $
		[0,1,1,1,0,0,0,0,1,1,0,0,1,1,1,0], $
		[0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0], $
		[0,0,1,1,1,0,1,1,1,1,1,1,1,1,0,0], $
		[0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0], $
		[0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0], $
		[0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0], $
		[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0] ],7)

	cycle_btn = rotate([ $
		[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], $
		[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0], $
		[0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0], $
		[0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0], $
		[0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0], $
		[0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0], $
		[0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0], $
		[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0], $
		[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0], $
		[0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0], $
		[0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0], $
		[0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0], $
		[0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0], $
		[0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0], $
		[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0], $
		[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0] ],7)

	blink_btn = rotate([ $
		[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], $
		[0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0], $
		[0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0], $
		[0,1,1,1,1,1,1,0,1,0,1,1,1,1,0,0], $
		[0,1,1,1,1,1,0,1,1,0,1,1,1,1,1,0], $
		[0,1,1,1,1,0,1,1,1,0,1,1,1,1,0,0], $
		[0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0], $
		[0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0], $
		[0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0], $
		[0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0], $
		[0,0,1,1,1,1,0,1,1,0,1,1,1,1,1,0], $
		[0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0], $
		[0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,0], $
		[0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0], $
		[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0], $
		[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0] ],7)

	if not keyword_set(black) then begin
		forward_btn = bytscl(forward_btn)
		pause_btn = bytscl(pause_btn)
		loop_btn = bytscl(loop_btn)
		cycle_btn = bytscl(cycle_btn)
		blink_btn = bytscl(blink_btn)
		fastforward_btn = bytscl(shift(forward_btn,-4,0) or $
			shift(forward_btn,3,0))
	endif else begin
		forward_btn = bytscl(-1*forward_btn)
		pause_btn = bytscl(-1*pause_btn)
		loop_btn = bytscl(-1*loop_btn)
		cycle_btn = bytscl(-1*cycle_btn)
		blink_btn = bytscl(-1*blink_btn)
		fastforward_btn = bytscl(shift(forward_btn,-4,0) and $
			shift(forward_btn,3,0))
	endelse

	if keyword_set(gray) then begin
		gray = bytarr(16,16)
		for i=0,15,2 do for j=0,15,2 do begin
			gray[i,j] = 255b
			gray[i+1,j+1] = 255b
		endfor
		forward_btn = bytscl(forward_btn or gray)
		pause_btn = bytscl(pause_btn or gray)
		loop_btn = bytscl(loop_btn or gray)
		cycle_btn = bytscl(cycle_btn or gray)
		blink_btn = bytscl(blink_btn or gray)
		fastforward_btn = bytscl(fastforward_btn or gray)
	endif

	backward_btn = bytscl(rotate(forward_btn,5))
	fastbackward_btn = bytscl(rotate(fastforward_btn,5))

	return, create_struct('forward', cvttobm(forward_btn), $
		'backward', cvttobm(backward_btn), $
		'fastforward', cvttobm(fastforward_btn), $
		'fastbackward', cvttobm(fastbackward_btn), $
		'pause', cvttobm(pause_btn), $
		'loop', cvttobm(loop_btn), $
		'cycle', cvttobm(cycle_btn), $
		'blink', cvttobm(blink_btn))
end